<!DOCTYPE html>
<html>

<!-- BEGIN: Head -->

<head>
    <title>Dashboard</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="{{ asset('../dist/images/logo.svg') }}" rel="shortcut icon">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <script src="{{ asset('//ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js') }}"></script>
    <script src="https://cdn.ckeditor.com/ckeditor5/40.0.0/classic/ckeditor.js"></script>
    <script src="{{ asset('https://maxcdn.bootstrapcdn.com/bootstrap/3.3.6/js/bootstrap.min.js') }}"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <link href="{{ asset('dist/css/adminlte.min.css') }}" rel="stylesheet">
    <link rel="stylesheet" href="{{ mix('dist/css/app.css') }}" />
    <link rel="stylesheet" href="https://cdn.datatables.net/1.9.4/css/jquery.dataTables.css" />
</head>
<!-- END: Head -->

<body>
    <div class="flex">
        <!-- BEGIN: Side Menu -->
        <nav class="side-nav">
            <a href="/dashboard" class="intro-x flex items-center pl-5 pt-4">
                <img alt="Rubick Tailwind HTML Admin Template" class="w-6" src="../dist/images/logo.svg">
                <span class="hidden xl:block text-white text-lg ml-3">
                    Dashboard
                </span>
            </a>
            <div class="side-nav__devider my-6"></div>
            <ul>
                <li>
                    <a class="side-menu side-menu--active">
                        <div class="side-menu__icon"> <i data-feather="home"></i> </div>
                        <div class="side-menu__title" style="cursor:pointer">
                            Dashboard
                            <div class="side-menu__sub-icon transform rotate-180"> </div>
                        </div>
                    </a>
                </li>

                <!-- ///// 1 - BLOGS  /// -->
                <li>
                    <a class="side-menu">
                        <div class="side-menu__icon"> <i data-feather="file-text"></i> </div>
                        <div class="side-menu__title" style="cursor:pointer">
                            Blogs
                            <div class="side-menu__sub-icon "> <i data-feather="chevron-down"></i> </div>
                        </div>
                    </a>
                    <ul style="margin-left: 10px;">
                        <li>
                            <a href="/add-blog" class="side-menu">
                                <div class="side-menu__icon"> <i data-feather="edit"></i></i> </div>
                                <div class="side-menu__title"> Add New </div>
                            </a>
                        </li>
                        <li>
                            <a href="/show-blog" class="side-menu">
                                <div class="side-menu__icon"> <i data-feather="clipboard"></i> </div>
                                <div class="side-menu__title"> View All </div>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- ///// 2 - Vendor  /// -->
                <li>
                    <a class="side-menu">
                        <div class="side-menu__icon"> <i data-feather="users"></i> </div>
                        <div class="side-menu__title" style="cursor:pointer">
                            Vendor
                            <div class="side-menu__sub-icon "> <i data-feather="chevron-down"></i> </div>
                        </div>
                    </a>
                    <ul style="margin-left: 10px;">
                        <li>
                            <a href="/add-vendor" class="side-menu">
                                <div class="side-menu__icon"> <i data-feather="edit"></i></i> </div>
                                <div class="side-menu__title"> Add New </div>
                            </a>
                        </li>
                        <li>
                            <a href="/show-vendor" class="side-menu">
                                <div class="side-menu__icon"> <i data-feather="clipboard"></i> </div>
                                <div class="side-menu__title"> View All </div>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- ///// 3 - User  /// -->
                <li>
                    <a class="side-menu">
                        <div class="side-menu__icon"> <i data-feather="users"></i> </div>
                        <div class="side-menu__title" style="cursor:pointer">
                            Registered user
                            <div class="side-menu__sub-icon "> <i data-feather="chevron-down"></i> </div>
                        </div>
                    </a>
                    <ul style="margin-left: 10px;">

                        <li>
                            <a href="/show-user" class="side-menu">
                                <div class="side-menu__icon"> <i data-feather="clipboard"></i> </div>
                                <div class="side-menu__title"> View All </div>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- ///// 3 - ORDERS  /// -->
                <li>
                    <a class="side-menu">
                        <div class="side-menu__icon"> <i data-feather="package"></i> </div>
                        <div class="side-menu__title" style="cursor:pointer">
                            Orders
                            <div class="side-menu__sub-icon "> <i data-feather="chevron-down"></i> </div>
                        </div>
                    </a>
                    <ul style="margin-left: 10px;">

                        <li>
                            <a href="/show-order" class="side-menu">
                                <div class="side-menu__icon"> <i data-feather="clipboard"></i> </div>
                                <div class="side-menu__title"> View All </div>
                            </a>
                        </li>
                    </ul>
                </li>
   
                <!-- ///// 3 - CUSTOM ORDERS  /// -->
                <li>
                    <a class="side-menu">
                        <div class="side-menu__icon"> <i data-feather="package"></i> </div>
                        <div class="side-menu__title" style="cursor:pointer">
                            Custom Orders
                            <div class="side-menu__sub-icon "> <i data-feather="chevron-down"></i> </div>
                        </div>
                    </a>
                    <ul style="margin-left: 10px;">

                        <li>
                            <a href="/show-custom-order" class="side-menu">
                                <div class="side-menu__icon"> <i data-feather="clipboard"></i> </div>
                                <div class="side-menu__title"> View All </div>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- ///// 4 - SUBSCRIPTION  /// -->
                <li>
                    <a class="side-menu">
                        <div class="side-menu__icon"> <i data-feather="trending-up"></i> </div>
                        <div class="side-menu__title" style="cursor:pointer">
                            Subscription
                            <div class="side-menu__sub-icon "> <i data-feather="chevron-down"></i> </div>
                        </div>
                    </a>
                    <ul style="margin-left: 10px;">

                        <li>
                            <a href="/show-3-bouquet" class="side-menu">
                                <div class="side-menu__icon"> <i data-feather="calendar"></i> </div>
                                <div class="side-menu__title"> 3 Bouquet </div>
                            </a>
                        </li>
                        <li>
                            <a href="/show-6-bouquet" class="side-menu">
                                <div class="side-menu__icon"> <i data-feather="calendar"></i> </div>
                                <div class="side-menu__title"> 6 Bouquet </div>
                            </a>
                        </li>
                        <li>
                            <a href="/show-9-bouquet" class="side-menu">
                                <div class="side-menu__icon"> <i data-feather="calendar"></i> </div>
                                <div class="side-menu__title"> 9 Bouquet </div>
                            </a>
                        </li>
                        <li>
                            <a href="/show-ongoing-bouquet" class="side-menu">
                                <div class="side-menu__icon"> <i data-feather="rotate-ccw"></i> </div>
                                <div class="side-menu__title"> On Going </div>
                            </a>
                        </li>
                    </ul>
                </li>

            </ul>
        </nav>
        <!-- END: Side Menu -->

        <div class="content">
            <!-- BEGIN: Top Bar -->
            <div class="top-bar">
                <!-- BEGIN: Breadcrumb -->
                <nav aria-label="breadcrumb" class="-intro-x mr-auto hidden sm:flex">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a style="cursor:pointer">Hello</a></li>
                        <li class="breadcrumb-item active" aria-current="page" style="cursor:pointer">{{Auth::user()->name}}</li>
                    </ol>
                </nav>
                <!-- END: Breadcrumb -->

                <!-- BEGIN: Account Menu -->
                <div class="intro-x dropdown w-8 h-8">
                    <div class="dropdown-toggle w-8 h-8 rounded-full overflow-hidden shadow-lg image-fit zoom-in" role="button" aria-expanded="false" data-tw-toggle="dropdown">
                        <img alt="Rubick Tailwind HTML Admin Template" src="../dist/images/profile-8.jpg">
                    </div>
                    <div class="dropdown-menu w-56">
                        <ul class="dropdown-content bg-primary text-white">
                            <li class="p-2">
                                <div class="font-medium"> User :: {{Auth::user()->name}} </div>
                            </li>
                            <li>
                                <a href="/logout" class="dropdown-item hover:bg-white/5">
                                    <i data-feather="toggle-right" class="w-4 h-4 mr-2"></i> Logout </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <!-- END: Account Menu -->
            </div>
            <!-- END: Top Bar -->
            @yield('content')
        </div>
    </div>
    <!-- BEGIN: JS Assets-->
    <script src="{{ asset('plugins/jquery/jquery.min.js')}}"></script>
    <script src="{{ asset('plugins/jquery-ui/jquery-ui.min.js')}}"></script>
    <script src="{{ asset('dist/js/app.js')}}"></script>
    <script src="{{ asset('jquery.js') }}"></script>
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{ asset('https://cdn.datatables.net/1.13.3/js/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('https://cdn.datatables.net/1.13.3/js/dataTables.bootstrap5.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery.mask/1.14.16/jquery.mask.min.js" integrity="sha512-pHVGpX7F/27yZ0ISY+VVjyULApbDlD0/X0rgGbTqCE7WFW5MezNTWG/dnhtbBuICzsd0WQPgpE4REBLv+UqChw==" crossorigin="anonymous"></script>
    @yield('script')
</body>

</html>