@extends('layout.main-dashboard')

@section('content')

<div style="margin-top:20px; padding:10px;" class="card-tools">
    <!-- FLASH MESSAGES START -->
    @if ($message = Session::get('Delete'))
    <div style="margin-top:10px;" class="alert alert-danger alert-block">
        <strong>{{ $message }}</strong>
    </div><br>
    @endif

    @if ($message = Session::get('Success'))
    <div style="margin-top:10px;" class="alert alert-success alert-block">
        <strong>{{ $message }}</strong>
    </div><br>
    @endif

    @if ($message = Session::get('Update'))
    <div style="margin-top:10px;" class="alert alert-success alert-block">
        <strong>{{ $message }}</strong>
    </div><br>
    @endif
    <!-- FLASH MESSAGES END -->

    <h3 style="margin-top:10px; font-size:18px; font-weight:bold;" class="float-left" class="card-title">Blogs Table</h3>
    <a href="/add-blog">
        <button type="button" class="btn btn-primary float-right"> Add New</button>
    </a>
</div>
<br>
<div style="margin-top:15px; width: 100%; padding:5px;">

</div>
<!-- MAIN CONTAINER -->
<div style="overflow-x:auto; background-color: #FFFFFF;margin-top:15px; border-radius: 25px;" class="p-5">
    <!-- TABLE -->
    <table class="table display nowrap" style="width:100%;" id="example">
        <thead>
            <tr>
                <th class="th">ID</th>
                <th class="th">Title</th>
                <th class="th">Blog Image</th>
                <th class="thh text-center whitespace-nowrap">Action</th>
            </tr>
        </thead>

        <tbody>
            @foreach ($blog_data as $blogs)
            <tr>
                <td style="vertical-align: middle; background-color: #FFFFFF"> {{ $blogs->id }} </td>
                <td class="tds"> {{ $blogs->title }} </td>
                <td class="tds">
                    <img src="{{ asset('uploads/'.$blogs->blog_image) }}" style="width: 100px;height: 70px;" />
                </td>
                <td class="tds">
                    <div class="flex justify-center items-center">
                        <div class="flex items-center card-tools">
                            <a class="flex items-center mr-3 eye" href="/view-blog/{{$blogs->id}}" style="cursor:pointer;"> <i data-feather="eye" class="w-4 h-4 mr-1 view"></i> View </a>
                            <a class="flex items-center mr-3" href="/edit-blog/{{$blogs->id}}"> <i data-feather="check-square" class="w-4 h-4 mr-1"></i> Edit </a>
                            <a class="flex items-center text-danger" href="/delete-blog/{{$blogs->id}}"> <i data-feather="trash-2" class="w-4 h-4 mr-1"></i> Delete </a>
                        </div>
                    </div>
                </td>
            </tr>

            @endforeach
        </tbody>
    </table>
</div>

<style>
    .tds {
        padding: 15px !important;
        height: 50px !important;
        vertical-align: middle !important;
        background-color: #FFF;
    }

    .thh {
        padding: 15px !important;
        vertical-align: middle !important;
    }

    .th {
        padding: 15px !important;
    }
</style>

<script type="text/javascript">
    $(document).ready(function() {
        $('#example').DataTable({
            responsive: true
        });

        $('body').ready(function() {
            $('#example').DataTable();
        });

    });
</script>
@endsection