<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\CustomOrder;
use App\Http\Controllers\Order;
use App\Http\Controllers\Vendor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('/register-user', [AuthController::class, 'Add_User']);
Route::get('/get-blogs', [AuthController::class, 'GetBlogs']);
Route::get('/get-blogs/{id}', [AuthController::class, 'GetBlogsDetail']);
Route::post('/add-vendor', [Vendor::class, 'Add_Vendor']);
Route::post('/place-order', [Order::class, 'Place_Order']);
Route::post('/place-order-item', [Order::class, 'Place_Order_Item']);


Route::post('/add-customorder', [CustomOrder::class, 'generateQRCode']);
