<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\CustomOrder;
use App\Http\Controllers\Order;
use App\Http\Controllers\Subscription;
use App\Http\Controllers\Vendor;
use App\Models\User;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [AuthController::class, 'checkUser']);
Route::get('/login', [AuthController::class, 'loginView']);
Route::post('/login-check', [AuthController::class, 'loginCheck']);
Route::get('/register', [AuthController::class, 'registerView']);
Route::post('/create-user', [AuthController::class, 'register']);
Route::get('/dashboard', [AuthController::class, 'dashboard']);
Route::get('/logout', [AuthController::class, 'logout']);
Route::get('/logout', [AuthController::class, 'logout']);
////////////////////   BLOG  ////////////////// 
Route::get('/add-blog', [BlogController::class, 'BlogView']);
Route::post('/add-blog', [BlogController::class, 'BlogPost']);
Route::get('/show-blog', [BlogController::class, 'BlogTable']);
Route::get('/delete-blog/{id}', [BlogController::class, 'BlogDelete']);
Route::get('/edit-blog/{id}', [BlogController::class, 'BlogEditView']);
Route::put('/edit-blog/{id}', [BlogController::class, 'BlogEditPost']);
Route::get('/view-blog/{id}', [BlogController::class, 'BlogViewContent']);
Route::post('/upload-blog-image', [BlogController::class, 'BlogImage'])->name('image.upload');

////////////////////   VENDORS  ////////////////// 
Route::get('/add-vendor', [Vendor::class, 'Add_Vendor_View']);
Route::post('/add-vendor', [Vendor::class, 'Add_Vendor_Post']);
Route::get('/show-vendor', [Vendor::class, 'Show_Vendor']);
Route::get('/delete-vendor/{id}', [Vendor::class, 'Delete_Vendor']);

////////////////////   ORDER  ////////////////// 
Route::get('/show-order', [Order::class, 'Show_Order_View']);

////////////////////   CUSTOM ORDER  ////////////////// 
Route::get('/show-custom-order', [CustomOrder::class, 'CustomOrderView']);
Route::get('/show-custom-order-qr-data/{email}', [CustomOrder::class, 'CustomOrderUserDataView']);

////////////////////   ShowSubcriptions.blade  //////////////////  
Route::get('/show-3-bouquet', [Subscription::class, 'Show_3_Bouquet_View']);
Route::get('/show-6-bouquet', [Subscription::class, 'Show_6_Bouquet_View']);
Route::get('/show-9-bouquet', [Subscription::class, 'Show_9_Bouquet_View']);
Route::get('/show-ongoing-bouquet', [Subscription::class, 'Show_Ongoing_View']);


////////////////////   WEBSITE REGIRSTERED USER  ////////////////// 
Route::get('/show-user', [AuthController::class, 'Show_User_View']);
Route::get('/edit-user/{id}', [AuthController::class, 'Edit_User_View']);
Route::put('/edit-user/{id}', [AuthController::class, 'Edit_User_Post']);
