<!DOCTYPE html>
<html>

<!-- BEGIN: Head -->

<head>
    <title>Registration - Dashboard</title>
    <meta charset="utf-8">
    <link href="<?php echo e(asset('dist/images/logo.svg')); ?>" rel="shortcut icon">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Rubick admin is super flexible, powerful, clean & modern responsive tailwind admin template with unlimited possibilities.">
    <meta name="keywords" content="admin template, Rubick Admin Template, dashboard template, flat admin template, responsive admin template, web app">
    <meta name="author" content="LEFT4CODE">
    <!-- BEGIN: CSS Assets-->
    <link rel="stylesheet" href="<?php echo e(mix('dist/css/app.css')); ?>" />
    <!-- END: CSS Assets-->
</head>
<!-- END: Head -->

<body class="login">

    <div class="container sm:px-10">
        <div class="block xl:grid grid-cols-2 gap-4">
            <!-- BEGIN: Register Info -->
            <div class="hidden xl:flex flex-col min-h-screen">
                <a href="" class="-intro-x flex items-center pt-5">
                    <img alt="Rubick Tailwind HTML Admin Template" class="w-6" src="<?php echo e(asset('dist/images/logo.svg')); ?>">
                    <span class="text-white text-lg ml-3">
                        Dashboard
                    </span>
                </a>
                <div class="my-auto">
                    <img alt="Rubick Tailwind HTML Admin Template" class="-intro-x w-1/2 -mt-16" src="<?php echo e(asset('dist/images/login.png')); ?>">
                    <div class="-intro-x text-white font-medium text-4xl leading-tight mt-10">Need Login <br> To Access Dashboard</div>
                    <div class="-intro-x mt-5 text-lg text-white text-opacity-70 dark:text-slate-400">Manage all your information in one place</div>
                </div>
            </div>
            <!-- END: Register Info -->
            <!-- BEGIN: Register Form -->
            <div class="h-screen xl:h-auto flex py-5 xl:py-0 my-10 xl:my-0">
                <div class="my-auto mx-auto xl:ml-20 bg-white dark:bg-darkmode-600 xl:bg-transparent px-5 sm:px-8 py-8 xl:p-0 rounded-md shadow-md xl:shadow-none w-full sm:w-3/4 lg:w-2/4 xl:w-auto">
                    <h2 class="intro-x font-bold text-2xl xl:text-3xl text-center xl:text-left">Hello, Registered First</h2>
                    <div class="intro-x mt-8">
                        <form action="/create-user" method="POST">
                            <?php echo e(csrf_field()); ?>

                            <input type="text" name="name" class="intro-x login__input form-control py-3 px-4 block" placeholder="First Name">
                            <input type="email" name="email" class="intro-x login__input form-control py-3 px-4 block mt-4" placeholder="Email">
                            <input type="password" name="password" class="intro-x login__input form-control py-3 px-4 block mt-4" placeholder="Password">

                    </div>
                    <div class="intro-x flex items-center text-slate-600 dark:text-slate-500 mt-4 text-xs sm:text-sm">
                        <input id="remember-me" type="checkbox" class="form-check-input border mr-2">
                        <label class="cursor-pointer select-none" for="remember-me">I agree to the all</label>
                        <a class="text-primary dark:text-slate-200 ml-1" href="">Privacy Policy</a>.
                    </div>
                    <div class="intro-x mt-5 xl:mt-8 text-center xl:text-left">
                        <button type="submit" class="btn btn-primary py-3 px-4 w-full xl:w-32 xl:mr-3 align-top">Register</button>
                        </form>
                        <a href="/login"><button class="btn btn-outline-secondary py-3 px-4 w-full xl:w-32 mt-3 xl:mt-0 align-top">Login</button></a>
                    </div>

                </div>
            </div>
            <!-- END: Register Form -->
        </div>
    </div>
    <!-- BEGIN: JS Assets-->
    <script src="<?php echo e(mix('dist/js/app.js')); ?>"></script>
    <!-- END: JS Assets-->
</body>

</html><?php /**PATH D:\OFFICE WORK\flowerrdBackend\resources\views/layout/register.blade.php ENDPATH**/ ?>