<?php

namespace App\Http\Controllers;

use App\Models\blog;
use App\Models\User;
use Illuminate\Support\Facades\Session;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    function checkUser()
    {
        if (Auth::user()) {
            return redirect('/dashboard');
        } else {
            return redirect('/login');
        }
    }
    function loginView()
    {
        return view('layout.login');
    }

    // REGISTRATION VIEW
    public function registerView()
    {
        return view('layout.register');
    }
    // REGISTRATION POST DATA
    public function register(Request $request)
    {
        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->password =  Hash::make($request->password);
        $user->role = 'user';
        $user->save();

        return redirect('/login')->with('success', 'User Registered Successfully, Please Login');
    }

    public function Show_User_View()
    {
        $user = DB::table('users')->where(['role' => 'user'])->get();
        return view('pages.RegisteredUser.ShowUser', ['user' => $user]);
    }

    public function Edit_User_View($id)
    {
        $user = user::find($id);
        return view('pages.RegisteredUser.EditUser', ['user' => $user]);
    }
    public function Edit_User_Post(Request $request, $id)
    {
        $user = user::find($id);
        $user->name = $request->name;
        $user->email = $request->email;
        $user->phone = $request->phone;
        $user->password =  Hash::make($request->password);
        $user->role = 'user';
        $user->update();
        return redirect('/show-user')->with('Success', 'User Record Update SuccessFully');
    }

    // LOGIN POST DATA
    public function loginCheck(Request $request)
    {
        $request->validate([
            'email' => 'required',
            'password' => 'required',
        ]);

        $credentials = $request->only('email', 'password');
        if (Auth::attempt($credentials)) {
            return redirect()->intended('dashboard')
                ->withSuccess('You have Successfully loggedin');
        }
        return redirect('/login')->with('error', 'Oppes! You have entered invalid credentials');
    }

    public function dashboard()
    {
        if (Auth::check()) {
            $Blogs = DB::table('blogs')->get();
            $CountBlog = $Blogs->count();
            $Vendor = DB::table('vendors')->get();
            $CountVendor = $Vendor->count();
            $User = DB::table('users')->get();
            $CountUser = $User->count() - 1;

            return view('layout.dashboard', ['CountBlog' => $CountBlog, 'CountVendor' => $CountVendor, 'CountUser' => $CountUser]);
        } else {
            return redirect('/login')->with('error', 'Please Login First!');
        }
    }

    public function logout()
    {
        Session::flush();
        Auth::logout();
        return redirect('/login')->with('success', 'Logout Successfully!');
    }

    //////////////////////////////   API  /////////////////////////////////
    public function GetBlogs()
    {
        $Get_Blogs = blog::all();
        return response()->json($Get_Blogs);
    }

    public function GetBlogsDetail($id)
    {
        $Get_Blogs = blog::find($id);
        return response()->json($Get_Blogs);
    }

    public function Add_User(Request $request)
    {
        $user = new User();
        $user->name = $request->name;
        $user->email = $request->email;
        $user->phone = $request->phone;
        $user->password =  Hash::make($request->password);
        $user->role = 'user';
        $user->save();
        return response()->json($user);
    }
}
