<?php

namespace App\Http\Controllers;

use App\Models\blog;
use Illuminate\Http\Request;

class BlogController extends Controller
{
    public function BlogView()
    {
        return view("pages.Blog.AddBlog");
    }
    public function BlogPost(Request $request)
    {
        $fileName = time() . '.' . $request->image->extension();
        $request->file('image')->move('uploads', $fileName);

        $blog = new blog;
        $blog->title = $request->title;
        $blog->content = $request->blog;
        $blog->blog_image = $fileName;
        $blog->save();
        return redirect('/add-blog')->with('Success', 'Blog Add Successfully!');
    }
    public function BlogTable()
    {
        $Blog_Data = blog::all();
        return view("pages.Blog.ViewBlog", ['blog_data' => $Blog_Data]);
    }

    public function BlogDelete($id)
    {
        $Blog_Data = blog::find($id);
        $Blog_Data->delete();
        return redirect('/show-blog')->with('Delete', 'Blog Delete Successfully!');
    }

    public function BlogEditView($id)
    {
        $Blog_Data = blog::find($id);
        return view("pages.Blog.EditBlog", ['Blog_Data' => $Blog_Data]);
    }

    public function BlogEditPost(Request $request, $id)
    {
        $blog = blog::find($id);
        $fileName = time() . '.' . $request->image->extension();
        $request->file('image')->move('uploads', $fileName);
        $blog->title = $request->title;
        $blog->content = $request->blog;
        $blog->blog_image = $fileName;
        $blog->update();
        return redirect('/add-blog')->with('Success', 'Blog Update Successfully!');
    }

    public function BlogViewContent($id)
    {
        $Blog_Data = blog::find($id);
        return view('/pages.Blog.ViewContentBlog', ['blog_data' => $Blog_Data]);
    }

    public function BlogImage(Request $request)
    {
        if ($request->hasFile('upload')) {
            $originName = $request->file('upload')->getClientOriginalName();
            $fileName = pathinfo($originName, PATHINFO_FILENAME);
            $extension = $request->file('upload')->getClientOriginalExtension();
            $fileName = $fileName . '_' . time() . '.' . $extension;

            $request->file('upload')->move(public_path('media'), $fileName);

            $url = asset('media/' . $fileName);
            return response()->json(['fileName' => $fileName, 'uploaded' => 1, 'url' => $url]);
        }
    }
}
