<?php

namespace App\Http\Controllers;

use App\Models\custom_order; 
use Illuminate\Http\Request; 
use SimpleSoftwareIO\QrCode\Facades\QrCode;

class CustomOrder extends Controller
{
    public function CustomOrderUserDataView($email)
    {
        $data =  custom_order::where('email', $email)->get();
        // return  $data;
        return view('pages.CustomOrder.ViewCustomOrderUserData', ['data' => $data]);
    }

    public function CustomOrderView()
    {
        $data =  custom_order::all();
        return view('pages.CustomOrder.ViewCustomOrder', ['data' => $data]);
    }

    public function generateQRCode(Request $request)
    {

        $data = new custom_order();
        $data->company_name = $request->company_name;
        $data->full_name = $request->full_name;
        $data->phone = $request->phone;
        $data->email = $request->email;
        $data->description = $request->description;
        

        $image = $request->file('image');
        $imageName = time() . '.' . $image->extension();
        $image->move(public_path('userinfo'), $imageName);
        
        $data->video = $imageName;

        $email = $request->email;
        // return $data;
        $qrCode = QrCode::generate('https://minahi-dashboard.creatrixmultimedia.com/show-custom-order-qr-data/' . $email);
        $data->qrcode = $qrCode;
        // // Save the QR code image 
        $data->save();

        return response()->json(['message' => 'Successfull']);
    }
}
