<?php

namespace App\Http\Controllers;

use App\Models\vendor as ModelsVendor; 
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash; 

class Vendor extends Controller
{
    public function Add_Vendor_View()
    {
        return view('pages.Vendor.AddVendor');
    }

    public function Add_Vendor_Post(Request $request)
    {
        $Vendor = new ModelsVendor();
        $Vendor->name = $request->vendor_name;
        $Vendor->email = $request->vendor_email;
        $Vendor->password = Hash::make($request->vendor_password);
        $Vendor->phone = $request->vendor_phone;
        $Vendor->address = $request->vendor_address;
        $Vendor->save();
        return redirect('/show-vendor')->with('Success', 'Your Vendor Add SuccessFully');
    }

 

    public function Show_Vendor()
    {
        $Vendor = ModelsVendor::all();
        return view('pages.Vendor.ShowVendor', ['Vendor' => $Vendor]);
    }

    public function Delete_Vendor($id)
    {
        $Vendor = ModelsVendor::find($id);
        $Vendor->delete();
        return redirect('/show-vendor')->with('Delete', 'Vendor Delete SuccessFully');
    }

    ////////////////////////////    API    ////////////////////////////

    public function Add_Vendor(Request $request)
    {
        $Vendor = new ModelsVendor();
        $Vendor->name = $request->name;
        $Vendor->email = $request->email;
        $Vendor->password = Hash::make($request->password);
        $Vendor->phone = $request->phone;
        $Vendor->address = $request->address;
        $Vendor->save();
        return response()->json($Vendor);
    }
}
